
/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    drivers.c
 * \brief   This is the SMAC C source driver file for the HC(S)08
 * MCU and MC13192 transceiver.
 * \author  r01160
 * \version 4.1a
 * \date    2005/07/29 03:30:40 
 * 
 * \b Description:
 *
 * The driver controls all interfaces to/from the MC13192 by the SPI,
 * selected interrupt source and MCU GPIO's assigned to other MC13192
 * pins.The SMAC driver is the lowest layer of C code.
 * Actual hardware interconnects from the MCU to the MC13192 are 
 * defined in the MC13192_hw_config.h header file.
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 16/11/2005 Doc. update to Doxygen compliant by Mario Rodriguez r12369c
 */ 
 
#include "smac_mcu_hw_config.h"
#include "smac_pub_def.h"
#include "smac_drivers.h"
#include "smac_simple_phy.h"
#include "smac_MC13192_hw_config.h"
#include "smac_MC13192_regs.h"
#include "smac_mcu_spi_config.h"
#include "smac_app.h"
#include "hprfgw_rfDiagnostics.h"
#include "smac_802_15_4_shim.h"

/* Globals */
tRxPacket *psDrvRxPacket;           //!< Where the packet received will be stored
tCCAMeasurement sDrvCCAReading;     //!< NOT USED  
UINT8 gu8IRQValue = 0;							//!< IRQ value
UINT16 gu8TxPktLenDefault;
extern tPhyOptions gsPhyOptions;
volatile UINT16 g_u16StatusContent; // Used to test for CCA clear in transmit path.
UINT32 Rfdiags_numTimer1Ints = 0;
UINT32 Rfdiags_numLOUnLockInts = 0;
UINT32 Rfdiags_numInvalidPhyPacketsRecvd = 0;
UINT32 Rfdiags_numCCA_TxDone = 0;
UINT32 Rfdiags_numBadTimerISR = 0;
UINT16 u16StatusContentAtReset = 0;

UINT32 Rfdiags_getNumTimer1Ints(void) { return Rfdiags_numTimer1Ints; }
UINT32 Rfdiags_getNumLOUnLockInts(void) {return Rfdiags_numLOUnLockInts; }
UINT32 Rfdiags_getNumInvalidPhyPacketsRecvd(void) { return Rfdiags_numInvalidPhyPacketsRecvd; }
UINT32 Rfdiags_getNumCCA_TxDone(void) { return Rfdiags_numCCA_TxDone; }
UINT32 Rfdiags_getNumBadTimerISR(void) { return Rfdiags_numBadTimerISR; }



// Ack Packet setup - Change this for the future
extern tTxPacket gsAckPacket;
extern UINT8 gau8AckDataBuffer[8];

UINT32 Rfdiags_LowLevelInvalidRxPacketCnt;


/*!
 * \brief  MC13192 initiated IRQ interrupt handler.
 * The vector is defined in vectortable.c
 *
 * \return The interrupt will RTI unless valid data is recvd.
 * In this case a PDDataIndication function call-back will be 
 * executed first, followed by a RTI.
 *
 */
//void  MC13192_LISR(int vector_num)   
void  MC13192_HISR(void)   
{
    /* The vector is defined in vectortable.c */
    volatile UINT16 u16Temp, u16PktLenReg;      /* 
                                                 * Result of the status register
                                                 * read
                                                 */
#ifdef LOOK_FOR_IRQ_GLITCH
    volatile UINT16 u16Reg;
#endif
    UINT8 u8DataLength = 0;     /* Data length for the RX packet */

    //CLEAR_IRQ_FLAG(); /* Acknowledge the interrupt. MC13192 IRQ pin still low. */     

    UINT16 u16StatusContent = SPIDrvRead(STATUS_ADDR); /*
                                                 * Read the MC13192 status 
                                                 * register.
                                                */
//    DmConsolePrintf("============= interrupt status = %04hx =============\n", u16StatusContent);
	SMAC_LOG_DEBUG_STATE2(u16StatusContent);

    // MNT - 4/19/2007 -  This might cause problems - If we do get double interrupts
    // just handle it in the next ISR 
#ifdef LOOK_FOR_IRQ_GLITCH
    /* Test for IRQ glitch or possible fast double IRQ. */

    if(IRQFLAG() == 1){         //__isflag_int_enabled
    /* IRQ is low. Re-read status. */
        CLEAR_IRQ_FLAG(); /* Acknowledge the interrupt. MC13192 IRQ pin still low. */     
        u16Reg = SPIDrvRead(STATUS_ADDR);   /* Read the MC13192 status register. */
        u16StatusContent = u16StatusContent | u16Reg;   /* 
                                                         * Actual status is the OR 
                                                         * of both.
                                                         */
    }   
#endif // LOOK_FOR_IRQ_GLITCH
    if (Rf_Smac_802_PIB.rfDisabled == (UINT8)TRUE)
    {
		// Only listen to tx irq for additional transmissions and the reset irq
		u16StatusContent &= TX_IRQ_MASK | ATTN_IRQ_MASK;
    } // if (Rf_Smac_802_PIB.rfDisabled == TRUE)
    else
    {
		u16StatusContent &= TX_IRQ_MASK | RX_IRQ_MASK | ATTN_IRQ_MASK |			\
							CRC_VALID_MASK | TIMER1_IRQ_MASK | CCA_IRQ_MASK |	\
							LO_LOCK_IRQ_MASK | ARBERR_IRQ_MASK | RAMERR_IRQ_MASK | CCA_BIT_MASK;

    } // if (Rf_Smac_802_PIB.rfDisabled == TRUE)
    
    if ((u16StatusContent & ARBERR_IRQ_MASK) || (u16StatusContent & RAMERR_IRQ_MASK) || (u16StatusContent & LO_LOCK_IRQ_MASK))
    {

		u16StatusContentAtReset = u16StatusContent;

        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_HISR_REQ_SMAC_RST);
		// MNT - 6/22/2007 - Reset and send NACK
		SMAC_SM_ResetPhy_And_Nack();
		g_u16StatusContent = u16StatusContent;
		return;
      } // if ((u16StatusContent & ARBERR_IRQ_MASK) || (u16StatusContent & RAMERR_IRQ_MASK) || (u16StatusContent & LO_LOCK_IRQ_MASK))


    // MNT - 7/5/2007 - The PHY gets into a weird state if it comes back with a timer interrupt
    // along with CRC Valid. Check to see if this condition exists. If it does, just reset
    // the PHY and get out. This caused the PHY to lock up in an overnight test.
    // Look at GatewayIntoWeirdStateAfterISR.xls for more details.
    if ((u16StatusContent & (CRC_VALID_MASK|TIMER1_IRQ_MASK)) == (CRC_VALID_MASK|TIMER1_IRQ_MASK))
    {
      SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_HISR_TMRWITHCCAVALIDRESET);
      Rfdiags_numBadTimerISR++;
      // MNT - 7/5/2007 - Reset and send NACK
      SMAC_SM_ResetPhy_And_Nack();
      g_u16StatusContent = u16StatusContent;
      return;
    } // if ((u16StatusContent & (CRC_VALID_MASK|TIMER1_IRQ_MASK)) == (CRC_VALID_MASK|TIMER1_IRQ_MASK))



    if (gu8RTxMode != RX_MODE_WTO) {
        /* If timeout not being used, mask out timer. */
        u16StatusContent &= ~(TIMER1_IRQ_MASK);
    }
    if ((u16StatusContent & ~(CRC_VALID_MASK)) == 0) {
        /* If no status bits are set just return. */
        g_u16StatusContent = u16StatusContent;
        trace_printk("status = %hu. No bits set.\n", u16StatusContent);
        return;
    }


    /* DOZE Complete Interrupt */
    if ((u16StatusContent & DOZE_IRQ_MASK) != 0) {
        SPIDrvWrite(T2_HI_ADDR, 0x8000); /* disable the timer2 */
        u16Temp= SPIDrvRead(MODE2_ADDR);
        u16Temp &= 0xFFFC;				
        SPIDrvWrite(MODE2_ADDR, u16Temp);
    }  
    /* ATTN IRQ Handler*/
    if ((u16StatusContent & ATTN_IRQ_MASK) != 0) {
       /* 
        * If attn interrupt, set the rtx_state mirror.
        * For MC13192 V2.x devices, read the reset indication in R25/7 first. 
        * If a reset is indicated, call back to a reset handler. 
        */
        u16StatusContent = SPIDrvRead(RESIND_ADDR); /* 
                                                     * Read the MC13192 reset 
                                                     * indicator register.
                                                     */
        u16StatusContent &= RESET_BIT_MASK;
        if (u16StatusContent == 0) {            /* Reset */
            u16StatusContentAtReset = u16StatusContent;

            gu8RTxMode = MC13192_RESET_MODE;    /* 
                                                 * Set the rtx_state mirror to 
                                                 * idle with attn.
                                                 */
            PLMEMC13192ResetIndication();
        }
        else {
            gu8RTxMode = IDLE_MODE_ATTN;    /* 
                                             * Set the rtx_state mirror to idle
                                             * with attn.
                                             */
        }
        g_u16StatusContent = u16StatusContent;
        return;
    }
    /* TIMER1 IRQ Handler (Used for receiver timeout notification) */
    /// \review The check for RX_WTO mode might not be needed because
    /// we clear the bit a little bit earlier if we are not in that mode
    if ((u16StatusContent & TIMER1_IRQ_MASK) != 0)
	{
        /* If timeout ocurs (and timeout enabled), update mode mirror state. */  
        if (gu8RTxMode == RX_MODE_WTO) {
            // MNT - 7/20/2007 - Flag the completion of the transmission when timeout
            // occurs.
            gTxInProgress = 0;
#if defined (OS_NUCLEUS)
            NU_Set_Events(&TxRxTask.txEvent, RF_TX_TXDONE, NU_OR);
#elif defined (OS_WINCE)
			SetEvent(TxRxTask.hTxEvent);
#endif
			OsSignalEvent(TxRxTask.hTxEvent);
          /* Clear Timer1 if in RX_MODE_WTO */
            SPIDrvWrite(T1_HI_ADDR, 0x8000); /* Disables TC1 and clears IRQ */
            SPIDrvWrite(T1_LO_ADDR, 0x0000);
            psDrvRxPacket->u8Status = TIMEOUT;
            RTXENDeAssert();                 /* Forces the MC13192 to idle. */
            gu8RTxMode = IDLE_MODE;
            SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_RXWTO);
            g_u16StatusContent = u16StatusContent;
            PDDataIndication();              /* TIMEOUT notification */
            Rfdiags_numTimer1Ints++;
            return;
        } // if (gu8RTxMode == RX_MODE_WTO)
    } // if ((u16StatusContent & TIMER1_IRQ_MASK) != 0)

#if 0
    /* LO LOCK IRQ - Occurs when MC13192 loses LOCK */
    /* For receive cycles, re-enable. For transmit/CCA, abort. */
    if ((u16StatusContent & LO_LOCK_IRQ_MASK) != 0) {
        RTXENDeAssert(); /* Forces the MC13192 to idle. */
        Rfdiags_numLOUnLockInts++;
        /* Unlock from receive cycles */
        if ((gu8RTxMode == RX_MODE) || (gu8RTxMode == RX_MODE_WTO) || \
            (gu8RTxMode == CCA_MODE)) {
            /* Read the MC13192 trx register. Timer trigger off. */
            u16StatusContent = (SPIDrvRead(MODE_ADDR) & 0xFF7F); 
            SPIDrvWrite(MODE_ADDR, u16StatusContent);   /* 
                                                         * Re-write the trx 
                                                         * register.
                                                         */  
            RTXENAssert();          /* Re-start the sequence. */
        }
        else {
          // MNT - 7/20/2007 - Flag the completion of the transmission when 
          // lo unlock interrupt occurs. This is really an error condition.
          // We will get into this else to abort the transmission as described
          // above. In addition, tell the transmit task that an error occured.
          // This will allow it to send a failure and allow the retry mechanism
          // to kick in
          if (gTxInProgress == 1)
          {
            gTxInProgress = 0;
            gTxLOUnlocked = 1;
#if defined (OS_NUCLEUS)
            NU_Set_Events(&TxRxTask.txEvent, RF_TX_TXDONE, NU_OR);
#elif defined (OS_WINCE)
			SetEvent(TxRxTask.hTxEvent);
#endif
          } // if (gTxInProgress == 1)
         
          gu8RTxMode = IDLE_MODE;
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_LOLOCKED);
        }
        return;
    } // if ((u16StatusContent & LO_LOCK_IRQ_MASK) != 0)
#endif // if 0


    if ((gu8RTxMode == IDLE_MODE) || ((u16StatusContent & CCA_IRQ_MASK) != 0) || \
       ((u16StatusContent & TX_IRQ_MASK) != 0)) {
        /* If in idle mode already or if CCA or TX is done, just return. */
        RTXENDeAssert();            /* Forces the MC13192 to idle. */
        
        Rfdiags_numCCA_TxDone++;

        /* Check for Pulse TX Mode for PRBS9 Test mode sequence */
        if (gu8RTxMode == PULSE_TX_MODE)
		{
		      u16StatusContent = (SPIDrvRead(MODE_ADDR) & 0xFF7F); /* Read the MC13192 trx register. Timer trigger off. */
		      SPIDrvWrite(MODE_ADDR, u16StatusContent); /* Re-write the trx register. */  
  		      RTXENAssert(); /* Re-start the sequence. */
  		
  	         #if defined (MC13192_PA_PRESENT)
            MC1319xDrv_TxHighPowerEnable();       //Turn off the PA when TX is complete
            #endif
            g_u16StatusContent = u16StatusContent;
            return;
        } // if (gu8RTxMode == PULSE_TX_MODE)

        // MNT - 6/14/2007 - If we transmitted a packet, we now have to go to receive mode
        // as soon as we get the ISR. Check the mode - if we were in transmit or retransmit
        // mode then go to receive mode right away. Otherwise, we just transmitted an ACK or
        // we just got a CCA

        gu8RTxMode = IDLE_MODE;
        if ((u16StatusContent & TX_IRQ_MASK) != 0) 
        {
		  // MNT - 6/15/2007 - Flag the completion of the transmission.
          gTxInProgress = 0;
#if defined (OS_NUCLEUS)
          NU_Set_Events(&TxRxTask.txEvent, RF_TX_TXDONE, NU_OR);
#elif defined (OS_WINCE)
		  SetEvent(TxRxTask.hTxEvent);
#endif
		  OsSignalEvent(TxRxTask.hTxEvent);
          // MNT - 6/26/2007 - Do not turn on receiver if the packet sent was a broadcast
          // packet. This flag will be set when a message is received from the higher layers
          // before the data is sent over the air.
          // MNT - 8/16/07 - Make sure that we are waiting for a transmit interrupt before
          // turning on RXWTO mode. If we transmitted the last packet without the CCA being
          // enabled, 
          if ( (gTxWaitForCCA == TRUE) && (Smac_BroadcastTxInProgress == FALSE) && (Rf_Smac_802_PIB.rfDisabled != TRUE) )
            {
              SMAC_SM_TurnOnRxWTO(SMAC_TIMEOUT_PERIOD);
            } //if ((u16StatusContent & TX_IRQ_MASK) != 0)
        } // tx interrupt

        
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_CCATXDONE);
        g_u16StatusContent = u16StatusContent;
        return;
    }
    /* If rx is done */
    if ((u16StatusContent & RX_IRQ_MASK) != 0) 
    {
    	//DmConsolePrintf("============= Received a packet. =============\n");
        RTXENDeAssert();            /* Forces the MC13192 to idle. */
        if ((u16StatusContent & CRC_VALID_MASK) == 0) 
        {
            /* If an invalid CRC, restart receiver. */
            /* Read the MC13192 trx register. Timer trigger off. */
            u16StatusContent = (SPIDrvRead(MODE_ADDR) & 0xFF7F); 
            /* Update the trx register */          
            SPIDrvWrite(MODE_ADDR, u16StatusContent); 
            RTXENAssert(); /* Forces the MC13192 to enter the receive mode. */
            g_u16StatusContent = u16StatusContent;
            return;
        }
        else {
            /* Read received packet length register and mask off length bits */
            u16PktLenReg = SPIDrvRead(RX_PKT_LEN);
            u8DataLength = (UINT8) (u16PktLenReg & 0x7F);
/// \todo
// MNT - 4/27/2007 - Change the datalength to the correct value (size of header) 
            if (u8DataLength < 3) /* Rx_pkt_length is bad when <5 because of CRC and byte codes. */
            {
                /* Read the MC13192 trx register. Timer trigger off. */                
                u16StatusContent = (SPIDrvRead(MODE_ADDR) & 0xFF7F); 
                /* Update the trx register. */ 
                SPIDrvWrite(MODE_ADDR, u16StatusContent);
                /* Forces the MC13192 to enter the receive mode. */
                RTXENAssert();
                Rfdiags_LowLevelInvalidRxPacketCnt++;
                g_u16StatusContent = u16StatusContent;
                return;
            }
   
/// \todo
// MNT - 4/27/2007 - THis will have to be a different check now - 
#if 0
            /* Test the Byte Codes */
            u16Temp = SPIDrvRead2(RX_PKT); /* Get the code bytes */

            if (u16Temp != 0xFF7E) 
            {
                Rfdiags_numInvalidPhyPacketsRecvd++;
                /* Read the MC13192 trx register. Timer trigger off. */                
                u16StatusContent = (SPIDrvRead(MODE_ADDR) & 0xFF7F); 
                /* Update the trx register. */ 
                SPIDrvWrite(MODE_ADDR, u16StatusContent);
                /* Forces the MC13192 to enter the receive mode. */
                RTXENAssert();  
                return;
            }
#endif            
            /* A valid packet has been received. */
            gu8RTxMode = IDLE_MODE;             /* Set the rtx_state to idle */
            SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_VALIDPKT);
            // MNT - 5/21/2007 - We should not just disable the timer whenever we
            // receive a packet. The filtering portion in the MCPSDataIndication function
            // should take care of this
#if 0
            SPIDrvWrite(T1_HI_ADDR, 0x8000);    /* 
                                                 * Disables TC1 and clears the 
                                                 * IRQ. 
                                                 */
            SPIDrvWrite(T1_LO_ADDR, 0x0000);
#endif
            psDrvRxPacket->u8DataLength = u8DataLength;
            psDrvRxPacket->u8Status = SMAC_SUCCESS;
            psDrvRxPacket->lqi = ((u16PktLenReg >> 8) & 0xFF);
            g_u16StatusContent = u16StatusContent;
            PDDataIndication(); /* Notify PHY that there is data available. */
            return;
        }
    }

//  NU_Activate_HISR(&RFPhyISR.RfPhyHISR);
    g_u16StatusContent = u16StatusContent;
}






/**
 *
 * \date        05-25-2007
 *
 * \author      mtalreja
 *
 * \brief       MC13192_MiniISRForACK
 *
 * \detail      This handles the flags when sending an ACK. It handles errors in
 *              addition to looking for the ack
 *              
 *
 * \return      
 *
 * \retval      
 *
 * \param void 
 */
void  MC13192_MiniISRForACK(void)   
{
    /* The vector is defined in vectortable.c */
    //volatile UINT16 u16Reg, u16Temp;   
                                                /* 
                                                 * Result of the status register
                                                 * read
                                                 */
    UINT8 u8DataLength = 0;     /* Data length for the RX packet */

    //CLEAR_IRQ_FLAG(); /* Acknowledge the interrupt. MC13192 IRQ pin still low. */     

    UINT16 u16StatusContent = SPIDrvRead(STATUS_ADDR); /*
                                                 * Read the MC13192 status 
                                                 * register.
                                                 */

    SMAC_LOG_DEBUG_STATE2(u16StatusContent);

    // MNT - 5/25/2007 - only look for relevant masks
    if (Rf_Smac_802_PIB.rfDisabled == TRUE)
    {
      // Only listen to tx irq for additional transmissions and the reset irq
      u16StatusContent &= TX_IRQ_MASK | ATTN_IRQ_MASK;
    } // if (Rf_Smac_802_PIB.rfDisabled == TRUE)
    else
    {
    u16StatusContent &= TX_IRQ_MASK | ATTN_IRQ_MASK | LO_LOCK_IRQ_MASK;
    }  // if (Rf_Smac_802_PIB.rfDisabled == TRUE)

    /* ATTN IRQ Handler*/
    if ((u16StatusContent & ATTN_IRQ_MASK) != 0) {
       /* 
        * If attn interrupt, set the rtx_state mirror.
        * For MC13192 V2.x devices, read the reset indication in R25/7 first. 
        * If a reset is indicated, call back to a reset handler. 
        */
        u16StatusContent = SPIDrvRead(RESIND_ADDR); /* 
                                                     * Read the MC13192 reset 
                                                     * indicator register.
                                                     */
        u16StatusContent &= RESET_BIT_MASK;
        if (u16StatusContent == 0) {            /* Reset */
            gu8RTxMode = MC13192_RESET_MODE;    /* 
                                                 * Set the rtx_state mirror to 
                                                 * idle with attn.
                                                 */
            PLMEMC13192ResetIndication();
        } // if (u16StatusContent == 0)
        else {
            gu8RTxMode = IDLE_MODE_ATTN;    /* 
                                             * Set the rtx_state mirror to idle
                                             * with attn.
                                             */
        } // if (u16StatusContent == 0)
        g_u16StatusContent = u16StatusContent;
        return;
    } // if ((u16StatusContent & ATTN_IRQ_MASK) != 0)

    /* LO LOCK IRQ - Occurs when MC13192 loses LOCK */
    /* For receive cycles, re-enable. For transmit/CCA, abort. */
    if ((u16StatusContent & LO_LOCK_IRQ_MASK) != 0) {
        RTXENDeAssert(); /* Forces the MC13192 to idle. */
        Rfdiags_numLOUnLockInts++;
        gu8RTxMode = IDLE_MODE;
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_LOLOCKED);
        g_u16StatusContent = u16StatusContent;
        return;
    }
    if ((u16StatusContent & TX_IRQ_MASK) != 0) 
    {
        /* If TX is done, just return. */
        RTXENDeAssert();            /* Forces the MC13192 to idle. */
        gu8RTxMode = IDLE_MODE;
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_IDLE_HISR_TXIRQ);
        g_u16StatusContent = u16StatusContent;
        return;
    } // if ((u16StatusContent & TX_IRQ_MASK) != 0))
    g_u16StatusContent = u16StatusContent;
}


